#!/bin/sh

# Copyright (c) 2006-2016 Intel Corporation. All rights reserved.
# This script configures Intel(R) Software Development Products.
EXIT_CODE_SUCCESS=0
EXIT_CODE_GUI_RUN_ERROR=1
EXIT_CODE_ERROR=2
EXIT_CODE_CANCEL=4

online_installer_flag=0
IRC_URL="https://registrationcenter.intel.com"
PRODUCT_ID="<product_id>"
download_url=
irc_url=
wget_secure_protocol=auto
[ "$(uname)" = "Darwin" ] && wget_secure_protocol=

bootstrap_checking_irc_message="Checking Intel(R) Software Development Products Registration Center availability..."
bootstrap_irc_is_not_reachable_error_1="Unable to connect to Intel(R) Software Development Products Registration Center"
bootstrap_irc_is_not_reachable_error_2="Some possible causes:"
bootstrap_irc_is_not_reachable_error_3="    1) Internet connection not found"
bootstrap_irc_is_not_reachable_error_4="        (Verify that you are connected to the internet.)"
bootstrap_irc_is_not_reachable_error_5="    2) Proxy settings are incorrect"
bootstrap_irc_is_not_reachable_error_6="        (If you are behind a proxy, please make sure that both of your http_proxy"
bootstrap_irc_is_not_reachable_error_7="         and https_proxy environment variables are set correctly."
bootstrap_irc_is_not_reachable_error_7a="        You can use --http-proxy and --https-proxy command line options to specify them."
bootstrap_irc_is_not_reachable_error_7b="        Please use --help option for details.)"
bootstrap_irc_is_not_reachable_error_8="    3) Firewall is on. Please make sure the firewall settings leave ports"
bootstrap_irc_is_not_reachable_error_9="       80 and 443 opened."
bootstrap_welcome_message="Welcome to the online installer for"
bootstrap_wget_protocol_message="Wget security protocol is:"
bootstrap_prerequisites_success="[success]"
bootstrap_prerequisites_failed="[failed]"

string_variables_names="bootstrap_prerequisites_failed bootstrap_prerequisites_success bootstrap_wget_protocol_message bootstrap_checking_irc_message bootstrap_irc_is_not_reachable_error_1 bootstrap_irc_is_not_reachable_error_2 bootstrap_irc_is_not_reachable_error_3 bootstrap_irc_is_not_reachable_error_4 bootstrap_irc_is_not_reachable_error_5 bootstrap_irc_is_not_reachable_error_6 bootstrap_irc_is_not_reachable_error_7 bootstrap_irc_is_not_reachable_error_8 bootstrap_irc_is_not_reachable_error_9 bootstrap_welcome_message"

touch_space()
{
    local dir_to_check=$1
    local dir_end_path='hags7823782318#@123kjhknmnzxmnz'
    local err=0

    if [ -d "$dir_to_check" ] ; then 
        if [ -w "$dir_to_check" ] ; then
            mkdir "$dir_to_check/$dir_end_path" >/dev/null 2>&1
            err=$?
            if [ "$err" = "0" ] ; then
                local test_file="$dir_to_check/$dir_end_path/test.sh"
                echo "#!/bin/sh" > $test_file
                echo "exit 0" >> $test_file
                chmod +x $test_file >/dev/null 2>&1
                $test_file >/dev/null 2>&1
                err=$?
                if [ "$err" != "0" ] ; then
                  err=2
                fi
                rm -f $test_file >/dev/null 2>&1
                rmdir "$dir_to_check/$dir_end_path" >/dev/null 2>&1
            fi
        else
            err=1
        fi
    else
        touch_space "`dirname $dir_to_check`" "$dir_end_path"
        err=$?
    fi

    return $err
}

check_free_space()
{
    location=$1
    need_space=$2
    real_location=$location
    while [ ! -d "$real_location" ] ; do
        real_location=$(dirname "$real_location")
    done
    exist_space=$(df -Pm "$real_location" | tail -n1 | tr -s "[:space:]" | cut -d ' ' -f 4)
    if [ "$need_space" -gt "$exist_space" ]; then
        echo "Error: not enough disk space in temporary folder \"$real_location\""
        echo "Available: ${exist_space}M"
        echo "Required: ${need_space}M"
        echo ""
        echo "Quitting!"
        exit $EXIT_CODE_CANCEL
    fi
}

check_cpu_model() {
    if [ "$(uname)" = "Darwin" ]; then
        CPU_FAMILY=$(echo $(sysctl -a | grep machdep.cpu.family |head -1|cut -d: -f2))
        CPU_MODEL=$(echo $(sysctl -a | grep machdep.cpu.model |head -1|cut -d: -f2))
    else
        CPU_FAMILY=$(echo $(grep family /proc/cpuinfo |head -1|cut -d: -f2))
        CPU_MODEL=$(echo $(grep model /proc/cpuinfo |head -1|cut -d: -f2))
    fi

    MIN_FAMILY=6
    MIN_MODEL=14

    if [ $CPU_FAMILY -lt $MIN_FAMILY ]; then
        echo "CPU is not supported."
        exit $EXIT_CODE_CANCEL
    elif [ $CPU_FAMILY -eq $MIN_FAMILY ] && [ $CPU_MODEL -lt $MIN_MODEL ]; then
        echo "CPU is not supported."
        exit $EXIT_CODE_CANCEL
    fi
}

prepare_pset_binary()
{
        pset_config_folder="$fullpath/pset"
        pset_engine_folder="$fullpath/pset/$my_arch"
        if [ "$(uname)" = "Darwin" ]; then
            pset_config_folder="`cd "$fullpath/../Resources/pset";pwd;cd - > /dev/null 2>/dev/null`"
            pset_engine_folder="$fullpath"
        elif [ "$pset_mode" = "uninstall" ]; then
            pset_config_folder="$fullpath/uninstall"
            pset_engine_folder="$fullpath/uninstall/$my_arch"
        fi
        pset_engine_binary="$pset_engine_folder/install_gui"
        pset_engine_cli_binary="$pset_engine_folder/install"

        # check the platform support
        if [ ! -r "$fullpath" ] || [ ! -x "$fullpath" ]; then
            echo "The installation script is launched from the directory which does not have read/execute access permissions."
            echo "Please copy the package to other location which is accessible by $USER user";
            echo 
            echo "Quitting!"
            exit $EXIT_CODE_CANCEL
        fi;
        if [ ! -f "$pset_engine_binary" ] && [ ! -f "$pset_engine_cli_binary" ]; then
            if [ ! -d "$pset_engine_folder" ]; then
                echo "The package does not support the platform it being run on."
                echo "Please check to be sure the correct architecture of package has been downloaded."
                echo ""
                echo "Quitting!"
                exit $EXIT_CODE_CANCEL
            fi
            if [ ! -x "$pset_engine_folder" ]; then
                if [ "yes" = "$skip_gui_install" ]; then
                    echo "Can not execute $pset_engine_cli_binary: permission denied."
                else
                    echo "Can not execute $pset_engine_binary: permission denied."
                fi
                echo "Please check the package was unpacked with proper permissions."
                echo ""
                echo "Quitting!"
                exit $EXIT_CODE_CANCEL
            fi

            echo "The package does not support the platform it being run on."
            echo "Please check to be sure the correct architecture of package has been downloaded."
            echo ""
            echo "Quitting!"
            exit $EXIT_CODE_CANCEL
        fi

        if [ ! -x "$pset_engine_binary" ]; then
            skip_gui_install=yes
            if [ ! -x "$pset_engine_cli_binary" ]; then
                echo "Can not execute $pset_engine_binary: permission denied."
                echo "Please check the package was unpacked with proper permissions."
                echo ""
                echo "Quitting!"
                exit $EXIT_CODE_CANCEL
            fi
        fi

        if [ -z "${libz_exist}" ]; then
            libz_path="$pset_engine_folder/libz"
        fi

        libqt_path="$pset_engine_folder/qt"

        [ "$(uname)" != "Darwin" ] && LD_LIBRARY_PATH="$fullpath/pset/$my_arch:$libqt_path:$libz_path:$LD_LIBRARY_PATH"
        export LD_LIBRARY_PATH


if [ "$(uname)" != "Darwin" ] && [ "$pset_mode" = "uninstall" ]; then
    # move PSET binary to temporary location
    temp_dir="$user_tmp/intel.pset.$USER.${HOSTNAME}_$(date +%m.%d.%H.%M.%S.%Y)"
    mkdir -p "$temp_dir/$my_arch"
    [ -f "$pset_engine_folder/install_gui" ] && cp $pset_engine_folder/install_gui $temp_dir/$my_arch
    cp $pset_engine_folder/install $temp_dir/$my_arch
    cp $pset_config_folder/mediaconfig.xml $temp_dir
    cp -r $pset_config_folder/images $temp_dir > /dev/null 2>&1
    cp $pset_config_folder/*.cab $temp_dir > /dev/null 2>&1
    pset_engine_binary="$temp_dir/$my_arch/install_gui"
    pset_engine_cli_binary="$temp_dir/$my_arch/install"
    pset_engine_folder="$temp_dir/$my_arch"
fi
}

parse_cmd_parameters()
{
    while [ $# -gt 0 ] ; do
    case "$1" in
    --silent|-s)
        silent_mode="yes"
        skip_uid_check="yes"
        ;;
    --help|-h|--version|-v)
        # show help message
        skip_uid_check="yes"
        skip_cd_eject="yes"
        skip_selinux_check="yes"
        minimal_launch="yes"
        params="$params $1"
        break
        ;;
    --user-mode)
        # run installation under current user privileges
        skip_uid_check="yes"
        ;;
    --ignore-cpu)
        # skip cpu checking
        skip_cpu_check="yes"
        ;;
    --cli-mode)
        # don't start GUI installer
        skip_gui_install="yes"
        cli_mode_params="--cli-mode"
        ;;
    --gui-mode)
        # Start GUI installer even if default is CLI
        skip_gui_install=no
        ;;
    --check_only)
        # Just perform basic checks without launching installer
        check_only="yes"
        ;;
    --http-proxy)
        export http_proxy="$2"
        shift
        ;;
    --https-proxy)
        export https_proxy="$2"
        shift
        ;;
    *)
    esac
    case "$1" in
    --tmp-dir|-t)
        if [ -z "$2" ]; then
            echo "Error: Please provide temporary folder."
            exit $EXIT_CODE_CANCEL
        fi
        user_tmp="$2"
        shift
        ;;
    --download-url)
        if [ -z "$2" ]; then
            echo "Error: download url must be specified."
            exit 1
        fi
        download_url="$2"
        echo "$download_url" | grep "\/$" > /dev/null 2>&1
        if [ "$?" = "1" ]; then
            download_url="${download_url}/"
        fi
        skip_proxy_detection=1

        shift
        ;;
     --irc-url)
        if [ -z "$2" ]; then
            echo "Error: IRC url must be specified."
            exit 1
        fi
        irc_url="$2"

        shift
        ;;
    --download-dir|-D)
        dir=$2
        if [ -z "$dir" ]; then
            echo "Error: Please provide download temporal folder."
            exit $EXIT_CODE_CANCEL
        fi
        if echo $dir | grep -q -s ^/ || echo $dir | grep -q -s ^~ ; then
            # absolute path
            download_tmp="$dir"
        else
            # relative path
            download_tmp="$runningdir/$dir"
        fi

        if [ ! -d "$download_tmp" ]; then
            echo "Error: $download_tmp doesn't look like a proper folder."
            echo "Please make sure that this folder exists and run installation again."
            exit $EXIT_CODE_CANCEL
        fi

        shift
        ;;
    *)
        if test "${1#-}" != "$1"; then
            params="$params $1"
        else
            params="$params '$1'"
        fi        
    esac
    if [ "$#" -gt "0" ]; then
        shift
    fi
    done
}

check_runningdir()
{
    if [ -n "$(echo "$fullpath" | egrep -e ':' -e '~' -e '&' -e '%' -e '#' -e '@' -e '\[' -e '\]' -e '\$' -e '=' -e '\)' -e '\(' -e '\*')" ] ; then
        echo "Error: Incorrect path to setup script. Setup can not be started"
        echo "if the path contains ':, ~, @, #, %, &, [, ], $, =, ), (, *' symbols."
        echo ""
        echo "Quitting!"
        exit $EXIT_CODE_CANCEL
    fi
}

get_strings()
{
    strings_file="$user_tmp/intel.pset.strings.$USER.${HOSTNAME}"
    if [ -f "$pset_engine_cli_binary" ]; then
        "$pset_engine_cli_binary" --TEMP_FOLDER="$temp_folder" --log-disable --__get_string__=$strings_file $params
    else
        "$pset_engine_binary" --TEMP_FOLDER="$temp_folder" --log-disable --__get_string__=$strings_file $params 2>/dev/null
    fi
    exit_code=$?
    if [ -f $strings_file ] ; then
        . $strings_file
        rm $strings_file >/dev/null 2>&1
    else
        exit $exit_code;
    fi
}

cli_root_nonroot_dialog()
{
    REPEAT_LOOP=1
    while [ "$REPEAT_LOOP" = 1 ]; do
        root_nonroot_desc="$LI_bash_root_nonroot"
        root_nonroot_help="$LI_bash_log_root_nonroot_help"
        if [ "$pset_mode" = "uninstall" ]; then
            root_nonroot_desc="$LI_bash_root_sudo"
            root_nonroot_help="$LI_bash_log_root_sudo_help"
        fi
        echo "$root_nonroot_desc"
        echo " "
        echo -n "$LI_bash_root_nonroot_question"
        read  usr_choice >/dev/null 2>&1
        if [ -z "$usr_choice" ]; then
            usr_choice=1
        fi
        case $usr_choice in
        1 )
            echo "$LI_bash_log_as_root"
            subcommand="sh $fullpath/$thisexec $cli_mode_params $params --http_proxy=$http_proxy --https_proxy=$https_proxy || true"
            rm -rf $temp_folder >/dev/null 2>&1
            sh -c "(exec su - -c \"$subcommand\")"
            if [ "$?" = "0" ]; then
                exit $EXIT_CODE_SUCCESS
            else 
                echo -n "$LI_bash_log_as_root_failed"
                read usr_choice >/dev/null 2>&1
                if [ "$usr_choice" = "y" ] || [ -z "$usr_choice" ]; then 
                    REPEAT_LOOP=1
                else
                    echo "$LI_bash_quit"
                    exit $EXIT_CODE_SUCCESS
                fi    
            fi
            ;;
        2 )
            echo "$LI_bash_log_as_sudo"
            subcommand="sh $fullpath/$thisexec $cli_mode_params $params --http_proxy=$http_proxy --https_proxy=$https_proxy || true"
            rm -rf $temp_folder >/dev/null 2>&1
            sh -c "(sudo su - -c \"$subcommand\")"
            if [ "$?" = $EXIT_CODE_SUCCESS ]; then
                exit $EXIT_CODE_SUCCESS
            else
                echo -n "$LI_bash_log_as_sudo_failed"
                read usr_choice >/dev/null 2>&1
                if [ "$usr_choice" = "y" ] || [ -z "$usr_choice" ]; then 
                    REPEAT_LOOP=1
                else
                    echo "$LI_bash_quit"
                    exit $EXIT_CODE_SUCCESS
                fi    
            fi
            ;;
        3 )
            if [ "$pset_mode" != "uninstall" ]; then
                echo "$LI_bash_log_as_user"
                REPEAT_LOOP=0
            fi
            ;;

        h )
            echo "$LI_bash_log_root_nonroot_help"
            echo -n "$LI_to_continue_question"
            read  dummy >/dev/null 2>&1
            ;;
        q )
            echo "$LI_bash_log_quit"
            rm -rf $temp_dir >/dev/null 2>&1
            exit 4
            ;;

        * ) echo "$LI_bash_log_invalid_choice"
            REPEAT_LOOP=1 
            ;;
        esac
    done
}

check_irc_availability ()
{
    if [ "$(uname)" = "Darwin" ]; then
        for protocol in "3" "2" "1" ; do
            curl -$protocol -L --connect-timeout 3 --retry 3 $irc_url >> $log_file 2>&1
            if [ $? -eq 0 ]; then
                wget_secure_protocol="-${protocol}"
                echo "${bootstrap_wget_protocol_message} '$wget_secure_protocol'" >> $log_file
                break
            fi
        done
    else
        for protocol in "SSLv3" "SSLv2" "TLSv1" ; do
            wget --secure-protocol=$protocol $irc_url --spider -T 3 -t 3 $irc_url >> $log_file 2>&1
            if [ $? -eq 0 ]; then
                wget_secure_protocol=$protocol
                echo "${bootstrap_wget_protocol_message} '$wget_secure_protocol'" >> $log_file
                break
            fi
        done
    fi

    if [ "$wget_secure_protocol" = "" ]; then
        return 1
    fi
    if [ "$(uname)" = "Darwin" ]; then
        curl $wget_secure_protocol -L --connect-timeout 3 --retry 3 http://registrationcenter-download.intel.com/ >> $log_file 2>&1
    else
        wget --spider --secure-protocol=$wget_secure_protocol -T 3 -t 3 http://registrationcenter-download.intel.com/ >> $log_file 2>&1
    fi
    return $?
}

# script start
thisexec=`basename "$0"`
thisdir=`dirname "$0"`
[ -z "$HOSTNAME" ] && HOSTNAME=$(hostname);
log_file=intel.bootstrap.$USER.${HOSTNAME}_$(date +%m.%d.%H.%M.%S.%Y).log
skip_gui_install=yes

trap "" TSTP # Disable Ctrl-Z

# detect bash script source execution
is_sourced=$(echo "$0" | grep "install.sh")
if [ -z "$is_sourced" ]; then
    echo "Script is running sourced."
    echo "ERROR: This script installs product and should be called directly. Exiting..."
    exit $EXIT_CODE_CANCEL
fi

if echo "$thisdir" | grep -q -s ^/ || echo "$thisdir" | grep -q -s ^~ ; then
# absolute path
   fullpath="$thisdir"
else
# relative path 
   runningdir=`pwd`
   fullpath="$runningdir/$thisdir"
fi
check_runningdir

system_cpu=`uname -m`
if [ "$system_cpu" = "x86_64" ]; then
    my_arch=32e
else
    my_arch=32
fi

if [ -f "/sbin/ldconfig" ]; then
    if [ "$my_arch" = "32" ]; then
        libz_exist=`/sbin/ldconfig -p | grep libz.so.1 | cut -d'>' -f2`
    elif [ "$my_arch" = "32e" ]; then
        libz_exist=`/sbin/ldconfig -p | grep libz.so.1 | grep x86-64 | cut -d'>' -f2`
    else
        libz_exist=`/sbin/ldconfig -p | grep libz.so.1 | grep IA-64 | cut -d'>' -f2`
    fi

    libz_exist="${libz_exist## }"
    libz_exist="${libz_exist%% }"
    if [ ! -f "$libz_exist" ]; then
        libz_exist=""
    fi
fi

unset libz_path
unset libqt_path

cli_mode_params=""
params=""
[ "$thisexec" = "uninstall.sh" ] && pset_mode="uninstall"
uninstall_detector="--PSET_MODE uninstall"
cmdline="$@"
if test "${cmdline#*$uninstall_detector}" != "$cmdline"; then
    pset_mode="uninstall"
else
    [ "$pset_mode" = "uninstall" ] && params="$params --PSET_MODE=uninstall"
fi

parse_cmd_parameters $@

if [ "$skip_cpu_check" != "yes" ]; then
    check_cpu_model
fi

#define and check temporary dir
if [ -z "$user_tmp" ]; then
    if [ -z "$TMPDIR" ]; then    
        user_tmp="/tmp"
    else
        if [ -d "$TMPDIR" ]; then
            user_tmp=$TMPDIR
        else
            user_tmp="/tmp"
        fi
    fi
fi

if [ ! -d "$user_tmp" ]; then
    echo "Error: $user_tmp doesn't look like a proper folder."
    echo "Please make sure that this folder exists and run installation again."
    echo ""
    echo "Quitting!"
    exit $EXIT_CODE_CANCEL
fi

touch_space $user_tmp
check=$?
if [ "$check" != "0" ]; then
    if [ "$check" = "1" ]; then
        echo "Error: No write permissions to \"$user_tmp\" temporary folder."
    elif [ "$check" = "2" ]; then
        echo "Error: No execute permissions in \"$user_tmp\" temporary folder."
    fi
    echo "Please fix the permissions or provide another temporary folder."
    echo "To provide another temporary folder please run setup"
    echo "with \"--tmp-dir [FOLDER]\" parameter."
    echo ""
    echo "Quitting!"
    exit $EXIT_CODE_CANCEL
fi

log_file="$user_tmp/$log_file"

if [ -z "$download_tmp" ]; then
    download_tmp=$user_tmp
fi
touch_space $download_tmp
check=$?
if [ "$check" != "0" ]; then
    echo "Error: No write permissions to \"$download_tmp\" temporary download folder."
    echo "Please fix the permissions or provide another temporary download folder."
    echo "To provide another temporary folder please run installation"
    echo "with \"--download-dir [FOLDER]\" parameter."
    exit $EXIT_CODE_CANCEL
fi
params="$params --download_dir=\"$download_tmp\""

required_tmp_space=5
check_free_space "$user_tmp" $required_tmp_space
check_free_space /tmp $required_tmp_space

if ! echo "$user_tmp" | grep -q -s ^/ && ! echo "$user_tmp" | grep -q -s ^~ ; then
   user_tmp="$fullpath/$user_tmp"
fi

[ -z "${check_only}" ] && temp_folder=$(mktemp -d "$user_tmp/install.XXXXXX")

prepare_pset_binary

# get string properties
[ "$(uname)" != "Darwin" ] && [ "yes" != "${minimal_launch}" ] && get_strings

# check selinux
if [ "$skip_selinux_check" != "yes" ]; then
    SELINUXENABLED_CMD=`which selinuxenabled 2>/dev/null`
    SELINUXGETBOOL_CMD=`which getsebool 2>/dev/null`
    SELINUXSETBOOL_CMD=`which setsebool 2>/dev/null`
    if [ -z "$SELINUXGETBOOL_CMD" ]; then
        if [ -f "/usr/sbin/getsebool" ]; then
            SELINUXGETBOOL_CMD="/usr/sbin/getsebool"
        fi
    fi
    if [ -z "$SELINUXSETBOOL_CMD" ]; then
        if [ -f "/usr/sbin/setsebool" ]; then
            SELINUXSETBOOL_CMD="/usr/sbin/setsebool"
        fi
    fi
    if [ -z "$SELINUXENABLED_CMD" ] ; then
        SELINUX_PATH="/etc/sysconfig/selinux"
        
        if [ -e "$SELINUX_PATH" ] ; then
            SELINUXENABLED="y"
            [ ! -z `cat "$SELINUX_PATH" | grep "SELINUX=disabled"` ] && SELINUXENABLED=""
            [ ! -z `cat "$SELINUX_PATH" | grep "SELINUX=permissive"` ] && SELINUXENABLED=""
        fi
    else
        $SELINUXENABLED_CMD
        [ $? -eq 0 ] && SELINUXENABLED="y"
        if [ -e "$SELINUX_PATH" ] ; then
            [ ! -z `cat "$SELINUX_PATH" | grep "SELINUX=permissive"` ] && SELINUXENABLED=""
        fi
    fi

    if [ "$SELINUXENABLED" = "y" ] ; then
        if [ -z "$SELINUXGETBOOL_CMD" ] || [ -z "$SELINUXSETBOOL_CMD" ]; then
            echo "Your system doesn't allow to determine and change Security-enhanced Linux* (SELinux) settings." \
                 "Please ensure that SELinux utilities 'getsebool' and 'setsebool' are installed on the system" \
                 "and available via PATH variable. Then start installation again."
            echo ""
            echo "Quitting!"
            exit $EXIT_CODE_CANCEL
        fi
    
        if [ "off" = "$( ${SELINUXGETBOOL_CMD} allow_execmod | cut -d' ' -f3)" ] ||
           [ "off" = "$( ${SELINUXGETBOOL_CMD} allow_execstack | cut -d' ' -f3)" ]; then
            echo "Your system is protected with Security-enhanced Linux* (SELinux). " \
                 "Initial product installation and licensing requires that SELinux variables \"allow_execmod\" and \"allow_execstack\" are set to \"on\"." \
                 "In your current set up at least one of these variables is set to \"off\", this may prevent activation of the product."
            echo ""
            echo "You may temporary disable this security setting by calling"
            echo "  setsebool allow_execmod on"
            echo "  setsebool allow_execstack on"
            echo "under root account."
            echo ""
            echo "No reboot will be required."
            echo ""
            echo "More information about SELinux can be found at http://www.nsa.gov/research/selinux/index.shtml"
            echo ""
            echo "Quitting!"
            exit $EXIT_CODE_CANCEL
        fi
    fi
fi




#resolve OS X proxy
if [ "$(uname)" = "Darwin" ] && [ "$skip_proxy_detection" != "1" ]; then
    system_proxy=$("$fullpath/../Resources/macProxyResolver" "registrationcenter.intel.com")
    system_http_proxy=$(echo "$system_proxy" | head -n 1)
    system_https_proxy=$(echo "$system_proxy" | head -n 2 | tail -n 1)

    [ -n "$system_http_proxy" ] && export http_proxy=$system_http_proxy
    [ -n "$system_https_proxy" ] && export https_proxy=$system_https_proxy
    params="--http_proxy=$http_proxy --https_proxy=$https_proxy $params"
fi

if [ -z "${check_only}" ] && [ "$download_url" = "" ] && ([ -f "$fullpath/../Resources/product.xml" ] || [ -f "$fullpath/product.xml" ]); then
    if [ "$irc_url" = "" ]; then
        irc_url=$IRC_URL
    fi
    download_url="${irc_url}/regcenter/getonlinepackagerooturl.aspx?id=${PRODUCT_ID}&file="
fi

#check if started under root account
[ -z "$UID" ] && UID=$(id -ru);
#if yes, no root-nonroot dialog will be shown
[ $UID -eq 0 ] && skip_uid_check=yes

if [ "$pset_mode" = "uninstall" ]; then
    show_sudo_dialog=0
    cache_dir=""
    if [ "$(uname)" = "Darwin" ]; then
        if [ $UID -eq 0 ]; then
            cache_dir="/opt/intel/ism/db/history/settings/"
        else
            cache_dir="$HOME/intel/ism/db/history/settings/"
        fi
    fi

    # check uninstall configuration file
    if [ -f "$cache_dir$pset_config_folder/uninstall.ini" ]; then
        INSTALL_MODE=$(cat "$cache_dir$pset_config_folder/uninstall.ini" | grep INSTALL_MODE= |  cut -d'=' -f2)
        ROOT_INSTALLATION=$(cat "$cache_dir$pset_config_folder/uninstall.ini" | grep ROOT_INSTALLATION= |  cut -d'=' -f2)
        NONRPM_DB_DIR=$(cat "$cache_dir$pset_config_folder/uninstall.ini" | grep NONRPM_DB_DIR= |  cut -d'=' -f2)

        # if configuration file is not bad, use it's content to detect if we need to show sudo_dialog
        if [ -n "$INSTALL_MODE" ]; then
            if [ "RPM" = "$INSTALL_MODE" -a $UID -ne 0 -o "yes" = "$ROOT_INSTALLATION" -a  $UID -ne 0 ]; then
                show_sudo_dialog=1
            fi
            params="$params --INSTALL_MODE=$INSTALL_MODE"
        fi
        if [ -n "$NONRPM_DB_DIR" ]; then
            params="$params --nonrpm_db_dir=$NONRPM_DB_DIR"
        fi
    else
        [ $UID -ne 0 ] && show_sudo_dialog=1
    fi

else
    show_sudo_dialog=1
fi

#add all layers to LD_LIBRARY_PATH
layers_path=""
for layer in "$pset_config_folder/"*.cab; do
    layer_file=$(basename "$layer");
    layer_name=${layer_file%.*};
    layers_path="${layers_path}:${temp_folder}/${layer_name}"
done

[ "$(uname)" != "Darwin" ] && export LD_LIBRARY_PATH="${layers_path}:${LD_LIBRARY_PATH}"
[ "$(uname)" = "Darwin" ] && export DYLD_LIBRARY_PATH="${layers_path}:${DYLD_LIBRARY_PATH}"

[ "yes" = "${check_only}" ] && exit 0

if [ "$(uname)" = "Darwin" ] && [ "$skip_proxy_detection" != "1" ] && [ -f "$fullpath/../Resources/macProxyResolver" ]; then
    system_proxy=$("$fullpath/../Resources/macProxyResolver" "registrationcenter.intel.com")
    system_http_proxy=$(echo "$system_proxy" | head -n 1)
    system_https_proxy=$(echo "$system_proxy" | head -n 2 | tail -n 1)

    [ -n "$system_http_proxy" ] && export http_proxy=$system_http_proxy
    [ -n "$system_https_proxy" ] && export https_proxy=$system_https_proxy
    params="--http_proxy=$http_proxy --https_proxy=$https_proxy $params"
fi

root_nonroot=
[ "yes" != "${skip_gui_install}" ] && [ "yes" != "${skip_uid_check}" ] && [ $show_sudo_dialog -eq 1 ] && root_nonroot="--RUN_MODE=root_nonroot"

if [ "$(uname)" = "Darwin" ]; then
    if [ -f "$fullpath/../Resources/product.xml" ]; then
        $pset_engine_binary --TEMP_FOLDER="$temp_folder" --download-url "$download_url" --download-dir "$download_tmp" --tmp-dir $user_tmp --wget-secure-protocol $wget_secure_protocol $silent_params $duplicate_params $params $root_nonroot 2>/dev/null
        online_installer_flag=1
        exit_code=$?
    fi
else
    if [ -f "$fullpath/product.xml" ]; then
        if [ "yes" = "${skip_gui_install}" ]; then
            "$pset_engine_cli_binary" --TEMP_FOLDER="$temp_folder" --download-url "$download_url" --tmp-dir $user_tmp --wget-secure-protocol $wget_secure_protocol $silent_params $duplicate_params $params
            online_installer_flag=1
            exit_code=$?
        else
            "$pset_engine_binary" --TEMP_FOLDER="$temp_folder" --download-url "$download_url" --tmp-dir $user_tmp --wget-secure-protocol $wget_secure_protocol $silent_params $duplicate_params $params $root_nonroot 2>/dev/null
            online_installer_flag=1
            exit_code=$?
        fi
    fi
fi

if [ "yes" != "${skip_gui_install}" ] && [ $online_installer_flag -ne 1 ]; then
    "$pset_engine_binary" --TEMP_FOLDER="$temp_folder" $params $root_nonroot 2>/dev/null
    exit_code=$?
fi

if [ "$exit_code" = "$EXIT_CODE_GUI_RUN_ERROR" ] && [ $online_installer_flag -ne 1 ]; then
    echo "Cannot run setup in graphical mode."
    echo "Setup will be continued in command-line mode."
    echo ""
    skip_gui_install=yes
fi

if [ "$UID" -ne 0 ] && [ "yes" = "${skip_gui_install}" ] && [ "yes" != "$skip_uid_check" ] && [ $show_sudo_dialog -eq 1 ] && [ $online_installer_flag -ne 1 ]; then
    if [ "yes" = "$silent_mode" ] && [ "$pset_mode" = "uninstall" ]; then
        echo "$LI_root_permissions_required_warning"
        exit $EXIT_CODE_CANCEL
    fi
    cli_root_nonroot_dialog
fi

if [ "yes" = "${skip_gui_install}" ] && [ $online_installer_flag -ne 1 ] ; then
    if [ ! -z "$pset_engine_cli_binary" ]; then
        "$pset_engine_cli_binary" --TEMP_FOLDER="$temp_folder" $params
        exit_code=$?
    else
        echo "Missing install binary file. Please check the package and try again."
    fi
fi

[ "yes" = "${minimal_launch}" ] && rm -rf $temp_folder >/dev/null 2>&1
[ "$(uname)" != "Darwin" ] && [ "$pset_mode" = "uninstall" ] && rm -rf $temp_dir >/dev/null 2>&1

## CD Eject Issue
if [ -f "$fullpath"/cd_eject.sh ]; then
    if [ -z "$skip_cd_eject" ]; then
        "$fullpath"/cd_eject.sh $PPID
        exit $exit_code
    fi
fi
exit $exit_code
